ManualTipping = {}
ManualTipping.MOD_NAME = g_currentModName

function ManualTipping.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations)
end

function Trailer.registerEvents(vehicleType)
    SpecializationUtil.registerEvent(vehicleType, "onStartTipping")
    SpecializationUtil.registerEvent(vehicleType, "onStopTipping")
    SpecializationUtil.registerEvent(vehicleType, "onEndTipping")
end

function ManualTipping.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "toggleisLoweringModeState",
        ManualTipping.toggleisLoweringModeState)
    SpecializationUtil.registerFunction(vehicleType, "controlTrailerHydraulic", ManualTipping.controlTrailerHydraulic)
    SpecializationUtil.registerFunction(vehicleType, "startManualTipping", ManualTipping.startManualTipping)
    SpecializationUtil.registerFunction(vehicleType, "stopManualTipping", ManualTipping.stopManualTipping)
    SpecializationUtil.registerFunction(vehicleType, "reverseTipping", ManualTipping.reverseTipping)
    SpecializationUtil.registerFunction(vehicleType, "stopReverseTipping", ManualTipping.stopReverseTipping)
end

function ManualTipping.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", ManualTipping)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdate", ManualTipping)
    SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", ManualTipping)
    SpecializationUtil.registerEventListener(vehicleType, "updateActionEvents", ManualTipping)
end

function ManualTipping:onLoad(savegame)
    local specManualTipping = self.spec_manualTipping

    specManualTipping.isValid = false

    specManualTipping.currentTippingAnimTime = 0
    specManualTipping.currentDoorAnimTime = 0
    specManualTipping.isLoweringMode = false

    specManualTipping.goUpText = g_i18n:getText("action_MANUAL_TIPPING_TOGGLE_UP", ManualTipping.modName)
    specManualTipping.goDownText = g_i18n:getText("action_MANUAL_TIPPING_TOGGLE_DOWN", ManualTipping.modName)

    specManualTipping.startUpText = g_i18n:getText("action_MANUAL_TIPPING_UP", ManualTipping.modName)
    specManualTipping.startDownText = g_i18n:getText("action_MANUAL_TIPPING_DOWN", ManualTipping.modName)

    specManualTipping.warningText = g_i18n:getText("warning_INVALID_TRAILER_TYPE", ManualTipping.modName)

    specManualTipping.isValid = true
end

function ManualTipping:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    local specManualTipping = self.spec_manualTipping

    if specManualTipping.isValid then
        if self.isClient then
            ManualTipping.updateActionEvents(self)
        end
    end

    if self.spec_trailer ~= nil then
        if self.spec_trailer.tipState == Trailer.TIPSTATE_CLOSED and self.spec_manualTipping.currentTippingAnimTime ~= 0 then
            self.spec_manualTipping.currentTippingAnimTime = 0
        end
    end
end

function ManualTipping:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
    local specManualTipping = self.spec_manualTipping
    if self.isClient and specManualTipping.isValid then
        self:clearActionEventsTable(specManualTipping.actionEvents)

        if isActiveForInputIgnoreSelection then
            local _, actionEventIdUp = self:addActionEvent(specManualTipping.actionEvents,
                InputAction.MANUAL_TIPPING_TOGGLE_UP, self, ManualTipping.actionEventBlock, false, true, false, true,
                nil)
            local _, actionEventControl = self:addActionEvent(specManualTipping.actionEvents,
                InputAction.MANUAL_TIPPING_UP, self, ManualTipping.actionEventBlock, true, true, false, true)

            g_inputBinding:setActionEventTextPriority(actionEventIdUp, GS_PRIO_NORMAL)
            g_inputBinding:setActionEventTextPriority(actionEventControl, GS_PRIO_NORMAL)

            ManualTipping.updateActionEvents(self)
        end
    end
end

function ManualTipping:updateActionEvents()
    local specManualTipping = self.spec_manualTipping
    local actionEventToggleUp = specManualTipping.actionEvents[InputAction.MANUAL_TIPPING_TOGGLE_UP]
    local actionEventControl = specManualTipping.actionEvents[InputAction.MANUAL_TIPPING_UP]

    if actionEventToggleUp ~= nil and actionEventControl ~= nil then
        if self.isActive then
            g_inputBinding:setActionEventText(actionEventToggleUp.actionEventId, specManualTipping.isLoweringMode and
                specManualTipping.goDownText or specManualTipping.goUpText)
            g_inputBinding:setActionEventText(actionEventControl.actionEventId, specManualTipping.isLoweringMode and
                specManualTipping.startDownText or specManualTipping.startUpText)
        end

        g_inputBinding:setActionEventActive(actionEventToggleUp.actionEventId, self.isActive)
    end
end

function ManualTipping:toggleisLoweringModeState(isLoweringMode)
    local specManualTipping = self.spec_manualTipping
    if isLoweringMode ~= specManualTipping.isLoweringMode then
        specManualTipping.isLoweringMode = isLoweringMode
    end
end

function ManualTipping:controlTrailerHydraulic(loweringMod, inputValue)
    local spec = self.spec_manualTipping

    local tipSideAvailable = self:getIsTipSideAvailable(self.spec_trailer.preferedTipSideIndex)
    local tipSide = self.spec_trailer.tipSides[self.spec_trailer.preferedTipSideIndex]

    if tipSideAvailable then
        if inputValue > 0 then
            if loweringMod then
                self:reverseTipping(spec, tipSide)
            else
                self:startManualTipping(spec, tipSide)
            end
        elseif inputValue == 0 then
            if loweringMod then
                self:stopReverseTipping(spec, tipSide)
            else
                self:stopManualTipping(spec, tipSide)
            end
        end
    else
        g_currentMission:showBlinkingWarning(spec.warningText, 2000)
    end
end

function ManualTipping.actionEventBlock(self, actionName, inputValue, callbackState, isAnalog)
    local specManualTipping = self.spec_manualTipping

    if actionName == InputAction.MANUAL_TIPPING_TOGGLE_UP then
        self:toggleisLoweringModeState(not specManualTipping.isLoweringMode)
    elseif actionName == InputAction.MANUAL_TIPPING_UP then
        self:controlTrailerHydraulic(specManualTipping.isLoweringMode, inputValue)
    end
end

function ManualTipping:onManualTippingToggleWay(actioName, inputValue)
    if inputValue == 1 then
        local specManualTipping = self.spec_manualTipping
        specManualTipping.isLoweringMode = not specManualTipping.isLoweringMode
    end
end

function ManualTipping:startManualTipping(spec, tipSide)
    local dischargeNodeIndex = self:getCurrentDischargeNodeIndex()
    local dischargeNode = self.spec_dischargeable.dischargeNodes[dischargeNodeIndex]

    if dischargeNode ~= nil then
        if dischargeNode.dischargeObject ~= nil then
            self:setDischargeState(Dischargeable.DISCHARGE_STATE_OBJECT)
        else
            self:setDischargeState(Dischargeable.DISCHARGE_STATE_GROUND)
        end

        self:setAnimationSpeed(tipSide.animation.name, tipSide.animation.speedScale)
        self:setAnimationSpeed(tipSide.doorAnimation.name, tipSide.doorAnimation.speedScale)

        self:playAnimation(tipSide.animation.name, tipSide.animation.speedScale, spec.currentTippingAnimTime, true)
        self:playAnimation(tipSide.doorAnimation.name, tipSide.doorAnimation.speedScale, spec.currentDoorAnimTime, true)
    end
end

function ManualTipping:stopManualTipping(spec, tipSide)
    spec.currentTippingAnimTime = self:getAnimationTime(tipSide.animation.name)
    spec.currentDoorAnimTime = self:getAnimationTime(tipSide.doorAnimation.name)

    self:setAnimationSpeed(tipSide.animation.name, 0)
    self:setAnimationSpeed(tipSide.doorAnimation.name, 0)

    self:setAnimationTime(tipSide.animation.name, spec.currentTippingAnimTime, false)
    self:setAnimationTime(tipSide.doorAnimation.name, spec.currentDoorAnimTime, false)

    if tipSide.animation.name ~= nil or tipSide.doorAnimation.name ~= nil then
        self:stopAnimation(tipSide.animation.name)
        self:stopAnimation(tipSide.doorAnimation.name)
    end
end

function ManualTipping:reverseTipping(spec, tipSide)
    self:setAnimationSpeed(tipSide.animation.name, tipSide.animation.closeSpeedScale)
    self:setAnimationSpeed(tipSide.doorAnimation.name, tipSide.doorAnimation.closeSpeedScale)

    self:playAnimation(tipSide.animation.name, tipSide.animation.closeSpeedScale, spec.currentTippingAnimTime, true)
    self:playAnimation(tipSide.doorAnimation.name, tipSide.doorAnimation.closeSpeedScale, spec.currentDoorAnimTime, true)

    local dischargeNodeIndex = self:getCurrentDischargeNodeIndex()
    local dischargeNode = self.spec_dischargeable.dischargeNodes[dischargeNodeIndex]

    if dischargeNode ~= nil then
        local isDoorClosed = self:getAnimationTime(tipSide.doorAnimation.name) <= 0.05
        local isTrailerLowered = self:getAnimationTime(tipSide.animation.name) <= 0.05

        if isDoorClosed and isTrailerLowered then
            self:setDischargeState(Dischargeable.DISCHARGE_STATE_OFF)
        end
    end
end

function ManualTipping:stopReverseTipping(spec, tipSide)
    spec.currentTippingAnimTime = self:getAnimationTime(tipSide.animation.name)
    spec.currentDoorAnimTime = self:getAnimationTime(tipSide.doorAnimation.name)

    self:setAnimationSpeed(tipSide.animation.name, 0)
    self:setAnimationSpeed(tipSide.doorAnimation.name, 0)

    self:setAnimationTime(tipSide.animation.name, spec.currentTippingAnimTime, false)
    self:setAnimationTime(tipSide.doorAnimation.name, spec.currentDoorAnimTime, false)

    local isDoorClosed = spec.currentDoorAnimTime <= 0.05
    if isDoorClosed then
        self:setDischargeState(Dischargeable.DISCHARGE_STATE_OFF)
    end

    if tipSide.animation.name ~= nil or tipSide.doorAnimation.name ~= nil then
        self:stopAnimation(tipSide.animation.name)
        self:stopAnimation(tipSide.doorAnimation.name)
    end
end
