--
-- UseYourTyres distance event
-- V1.0
-- @author 50keda
-- @date 26/04/2025
-- Copyright (C) 50keda, All Rights Reserved.

UytDistanceMultiplierEvent = {}
local UytDistanceMultiplierEvent_mt = Class(UytDistanceMultiplierEvent, Event)
InitEventClass(UytDistanceMultiplierEvent, "UytDistanceMultiplierEvent")

function UytDistanceMultiplierEvent.emptyNew()
	return Event.new(UytDistanceMultiplierEvent_mt)
end

function UytDistanceMultiplierEvent.new(tyresDistanceMultiplier)
	local self = UytDistanceMultiplierEvent.emptyNew()
	self.tyreDistanceMultiplier = tyresDistanceMultiplier
	return self
end

function UytDistanceMultiplierEvent.readStream(self, streamId, connection)
	self.tyreDistanceMultiplier = streamReadFloat32(streamId)

    self:run(connection)
end

function UytDistanceMultiplierEvent.writeStream(self, streamId, connection)
	streamWriteFloat32(streamId, self.tyreDistanceMultiplier)
end

function UytDistanceMultiplierEvent.run(self, connection)
	if self.tyreDistanceMultiplier ~= nil then
        UseYourTyres.tyreDistanceMultiplier = self.tyreDistanceMultiplier
		UseYourTyresSettings:updateSettings()      		

		if not connection:getIsServer() then
			g_server:broadcastEvent(self)
		else
			
		end
		-- print("Applied multiplier to the useYourTyres object: " .. UseYourTyres.tyreDistanceMultiplier)
	end
end


-- Fix:
-- 1. keyboard focus on settings
-- 2. sound on settings click